*———————————————————————————————————————————————————————————————————————————————
*********************************** Analysis ***********************************
********************************************************************************

clear all
set more on
set mat 800
capture log close

cd "$E"

global path "E:\Project1_empirical" // global path file
global census  "$path\Census"     // census data
global city    "$path\City"       // city yearbook
global iv      "$path\IV"         // IV dataset
global chips   "$path\CHIPs"      // CHIPs dataset
global working_data = "$path\5th Edition (Age 20 to 30) Mean Controls\Working Data" // working data be used in regression
global citynew "$path\City\Raw data" // mean vars over past years

use "$working_data\coredu", clear
order year, after(prefect)

/* 166 prefectures 47 exclude or not
119 unique prefectures 
71.69% regions are unique

codebook prefect if year==2002 
2002 54 prefectures  20 to 30 1972 to 1982, 
2007 18 prefectures
2013 94 prefectures
*/

*pooling three waves data

/*
sum cor_prefect srpref gini

    Variable |        Obs        Mean    Std. dev.       Min        Max
-------------+---------------------------------------------------------
 cor_prefect |        119    .6483302      .49526         -1          1
      srpref |        166    1.031251    .0754874   .7955182   1.342296
        gini |        156    .1731823     .134892          0   .5303407
*/

gen ln_m_pop_citybook = ln(m全市年末总人口万人)
gen ln_m_nonagri_pop = ln(m全市非农业人口万人)
gen m_pop_GR = m全市自然增长率
gen ln_m_num_emp = ln(m全市年末单位从业人员数万人)
gen ln_m_num_unemp = ln(m全市年末城镇登记失业人员数人)
gen ln_m_tone_emp_share = ln(m全市第一产业就业人员比例)
gen ln_m_ttwo_emp_share = ln(m全市第二产业就业人员比例)
gen ln_m_tthree_emp_share = ln(m全市第三产业就业人员比例)
gen ln_m_area = ln(m全市行政区域土地面积平公)
gen ln_m_pop_density = ln(m全市人口密度)
gen ln_m_GDP = ln(m全市GDP万元)
gen ln_m_GDPpc = ln(m全市GDPpc)
gen m_GDPgr = m全市GDPgr
gen mr_tone_to_GDP = m全市一产占GDP比
gen mr_ttwo_to_GDP = m全市二产占GDP比
gen mr_tthree_to_GDP = m全市三产占GDP比
gen ln_m_num_firms = ln(m全市工业企业数个)
gen ln_m_GDP_firms = ln(m全市工业总产值万元)
gen ln_m_mnum_emp = ln(m全市年平均从业人员数万人)
gen ln_m_GDP_domefundfirm = ln(m全市内资企业总产值万元)
gen ln_m_fixassets_bal = ln(m全市固定资产年均余额万元)
gen ln_m_liquiassets_bal = ln(m全市流动资产净值年均余额万元)
gen ln_m_FDI_use = ln(m全市实用FDI外资金额万美元)
gen ln_m_eduexp = ln(m全市教育支出万元)
gen ln_m_deposits = ln(m全市城乡居民储蓄年末余额万元)
gen ln_m_avewage = ln(m全市职工平均工资元)
gen ln_m_num_uni = ln(m全市普通高校数个)
gen ln_m_num_schools = ln(m全市普通中学数个)
gen ln_m_num_uniteachers = ln(m全市普通高校老师数个)
gen ln_m_num_schteachers = ln(m全市普通中学老师数个)

sum cor_prefect srpref gini, detail /* mean(cor_cor_prefect) = .6483302 StD = .49526 */
* mean(srpref) = 1.031251, StD = .0754874 *

* scatter cor_prefect srpref //scatter //

* twoway (scatter cor_prefect srpref) (lfit cor_prefect srpref)

/* 07/04/2022 */

/*varlist
poppref pop2030 share2030 pop1564 share1564 

gini

wage9010 wage8020 mwage afine1 apremium1 abonus1

THE VARIABLES ABOVE
*/

global allvarlist ln_m_pop_citybook ln_m_nonagri_pop m_pop_GR ln_m_num_emp ln_m_num_unemp ///
ln_m_tone_emp_share ln_m_ttwo_emp_share ln_m_tthree_emp_share ln_m_area ln_m_pop_density ///
ln_m_GDP ln_m_GDPpc m_GDPgr mr_tone_to_GDP mr_ttwo_to_GDP mr_tthree_to_GDP ln_m_num_firms ///
ln_m_GDP_firms ln_m_mnum_emp ln_m_GDP_domefundfirm ln_m_fixassets_bal ln_m_liquiassets_bal ///
ln_m_FDI_use ln_m_eduexp ln_m_deposits ln_m_avewage ln_m_num_uni ln_m_num_schools /// 
ln_m_num_uniteachers ln_m_num_schteachers

pwcorr cor_prefect srpref share2030 ln_m_pop_density ln_m_GDPpc ln_m_FDI_use ln_m_eduexp ///
ln_m_deposits ln_m_avewage ln_m_num_uni ln_m_num_schools ln_m_num_uniteachers ln_m_num_schteachers

global zlist share2030 ln_m_pop_density ln_m_GDPpc ln_m_avewage ln_m_FDI_use ln_m_deposits ///
ln_m_pop_citybook ln_m_fixassets_bal mr_tone_to_GDP mr_ttwo_to_GDP mr_tthree_to_GDP

global zlist2 share2030 ln_m_pop_density ln_m_GDPpc ln_m_avewage ln_m_FDI_use ln_m_deposits ///
ln_m_pop_citybook //include local demographic, economic, education information//

*———————————————————————————————————————————————————————————————————————————————
********************************* Final Results ********************************
********************************************************************************
eststo ra1: qui reg cor_prefect srpref ///
$zlist2, r 

eststo ra2: qui reg cor_prefect srpref ///
$zlist2, r cluster(prefect) 

eststo ra3: qui reg cor_prefect srpref ///
$zlist2 i.year, r

eststo ra4: qui reg cor_prefect srpref ///
$zlist2 i.year, r cluster(prefect)

/*eststo ra3: xi: qui areg cor_prefect srpref ///
$zlist2 i.year, absorb(prefect)  r cluster(prefect) degree of freedom problem */ 

estout ra*, cells(b(star fmt(%9.2f)) se(par)) starlevels(* .10 ** .05) ///
        stats(r2 N, fmt(%8.2f %8.0g) ) replace 

		* i.pv
		
esttab using "$working_data\reg1.tex", /// 
label b(2) se(2) r2(2) ///
title(education correlation between spouses) ///
addnote("Source: CHIPs, China City Statistical Yearbook, Census 2000, 2010") replace

eststo clear

/*
------------------------------------------------------------------------------------------------------
                      ra1            ra2            ra3            ra4            ra5            ra6  
                     b/se           b/se           b/se           b/se           b/se           b/se  
------------------------------------------------------------------------------------------------------
srpref              -2.12**        -2.12**        -2.07**        -2.07**        -3.21          -3.21  
                   (0.97)         (0.93)         (0.99)         (0.89)         (3.30)         (8.40)  
share2030            1.82           1.82           1.76           1.76           8.36           8.36  
                   (1.66)         (1.45)         (1.68)         (1.45)         (7.55)        (14.14)  
lnpopdensity         0.10           0.10           0.10           0.10           0.71           0.71  
                   (0.08)         (0.09)         (0.08)         (0.09)         (0.48)         (0.92)  
lngdppc             -0.20          -0.20          -0.19          -0.19           0.03           0.03  
                   (0.14)         (0.14)         (0.14)         (0.14)         (0.72)         (0.96)  
lnavewage           -0.02          -0.02          -0.08          -0.08          -1.44          -1.44  
                   (0.16)         (0.18)         (0.32)         (0.25)         (1.09)         (1.94)  
lnfdi               -0.14**        -0.14*         -0.15**        -0.15*         -0.37          -0.37  
                   (0.06)         (0.07)         (0.06)         (0.08)         (0.23)         (0.62)  
lndeposits           0.33**         0.33*          0.34**         0.34**         1.28*          1.28  
                   (0.13)         (0.17)         (0.14)         (0.16)         (0.61)         (1.30)  
lncolleges           0.01           0.01           0.01           0.01          -0.29          -0.29  
                   (0.08)         (0.05)         (0.08)         (0.05)         (0.33)         (0.47)  
lnhighscho~s        -0.39**        -0.39**        -0.39**        -0.39**        -0.19          -0.19  
                   (0.16)         (0.16)         (0.16)         (0.16)         (1.24)         (2.84)  
2002.year                                          0.00           0.00           0.00           0.00  
                                                    (.)            (.)            (.)            (.)  
2007.year                                          0.16           0.16           0.68           0.68  
                                                 (0.28)         (0.24)         (0.95)         (1.35)  
2013.year                                          0.09           0.09           0.69           0.69  
                                                 (0.41)         (0.38)         (2.12)         (2.42)  
1101.prefect                                                                     0.00           0.00  
                                                                                  (.)            (.)  
1401.prefect 
  .
  .
  .
  .
                                                                    0.39           0.39  
_cons                2.66           2.66*          3.06           3.06          -4.33          -4.33  
                   (1.97)         (1.46)         (2.76)         (2.27)        (18.93)        (32.31)  
------------------------------------------------------------------------------------------------------
r2                   0.12           0.12           0.13           0.13           0.85           0.85  
N                     101            101            101            101            101            101  
------------------------------------------------------------------------------------------------------
*/


*———————————————————————————————————————————————————————————————————————————————
*************************** check single regression ****************************
********************************************************************************

** // panel regression // **
xtset prefect year
xtreg cor_prefect srpref $zlist2, fe r cluster(prefect)
reg cor_prefect srpref $zlist2 i.prefect, r cluster(prefect) 
* the estimated coefficients are same, but SE are not *

xtreg cor_prefect srpref $zlist2 i.year, fe r cluster(prefect)
reg cor_prefect srpref $zlist2 i.year i.prefect, r cluster(prefect)
* the estimated coefficients are same, but SE are not *


*———————————————————————————————————————————————————————————————————————————————
**************************** Alternative controls ******************************
********************************************************************************

* regerssion 1a *
eststo rb1: qui reg cor_prefect srpref, r //without controls//
eststo rb2: qui reg cor_prefect srpref /// 
$zlist, r  /*control city info */

eststo rb3: qui reg cor_prefect srpref ///
$zlist i.year, r /*control year fix effects*/

eststo rb4: qui reg cor_prefect srpref ///
$zlist i.year i.prefect, r /*control all*/

estout rb*, cells(b(star fmt(%8.2f)) se(par)) starlevels(* .10 ** .05 *** .01) ///
        stats(r2_a aic  N, fmt(%8.2f %8.1f %8.0g) ) replace 

		
reg cor_prefect srpref
reg cor_prefect srpref $zlist
reg cor_prefect srpref $zlist2 //good//
reg cor_prefect srpref $zlist i.year, r
reg cor_prefect srpref $zlist2 i.year, r //good//




